function [ok]=udppoke(skt,add,data)
%function [ok]=udppoke(add,data,skt)
% Low level function for pokeing bytes to PIC over udp
% wrapper for udppokeb
% updated for octave 4-Feb-2018 - Ian Stothers
% Serial bits added
% 8-June- 2023 - Ian Stothers
if (ischar(skt)==1)
   skt=sktopen(skt);
endif
if (isfield(skt,'ser')==1)
  [ok]=serpoke(skt,add,data);
  return;
endif

len=max(size(data));
dptr=1;
while (len>0)
   put=min([len skt.max]);
   udppokeb(skt,add,data(dptr:(dptr+put-1)));
   len=len-put;
   add=add+put;
   dptr=dptr+put;
end
ok=1;
endfunction

function [ok]=udppokeb(skt,add,data)
%function [ok]=udppokeb(skt,add,data)
% Low level function for pokeing bytes to PIC over udp
% updated for octave 4-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers
global UDP_TX_ERRORS;
if (skt.bits==32)
if (min(size(UDP_TX_ERRORS))==0)
  UDP_TX_ERRORS=0;
end

sda=size(data);
sda=sda(1)*sda(2);
data=reshape(data,1,sda);
pbuf=uint8([5 1 0 0 bitand(sda,255) bitand(floor(sda/2.^8),255) bitand(floor(sda/2.^16),255) bitand(floor(sda/2.^24),255)...
      bitand(add,255) bitand(floor(add/2.^8),255) bitand(floor(add/2.^16),255) bitand(floor(add/2.^24),255) bitand(data,255)]);

retry=100;
ok=0;
b=[];


config_write('W',add,data);

while (retry>0)
  flushinput(skt.udp);
  write(skt.udp,pbuf,skt.ip,skt.port);
  flushoutput(skt.udp);
  b=read(skt.udp,8);

  if (max(size(b))>=8)
   if((b(1)==6)&(b(2)==1)&(b(3)==0)&(b(4)==0))
    ok=1;
    retry=-1;
   end
  endif   %(max(size(b))>=8)
  retry=retry-1;
  if(retry==-1)
    UDP_TX_ERRORS=UDP_TX_ERRORS+1;
  end
endwhile
else
[ok]=udppokeb16(skt,add,data);
endif
endfunction


function [ok]=udppokeb16(skt,add,data)
%function [ok]=udppokeb16(skt,add,data)
% Low level function for pokeing bytes to PIC over udp
% updated for octave 4-Feb-2018 - Ian Stothers
% updated for compatibility with 32 bit mcu octave 25/may/2020 - Ian Stothers
sda=size(data);
sda=sda(1)*sda(2);
data=reshape(data,1,sda);

pbuf=uint8([5 0 0 0 bitand(sda,255) floor(sda/256.0) bitand(add,255) floor(add/256.0) bitand(data,255)]);

retry=10;
ok=0;
b=[];

while (retry>0)
       write(skt.udp,pbuf,skt.ip,skt.port);
       flushoutput(skt.udp);
       b=double(read(skt.udp,6));

%  b=udp_read(skt.udp,6,20.0);
  if (max(size(b))>=4)
   if((b(1)==6)&(b(2)==0)&(b(3)==0)&(b(4)==0))
    ok=1;
    retry=0;
   end
  end
 retry=retry-1;
%end
end
endfunction

function [ok]=serpoke(skt,add,data)
%function [ok]=serpoke(add,data,skt)
% Low level function for pokeing bytes to PIC over serial
% Serial bits added
% 8-June- 2023 - Ian Stothers

pp_commands;
ok=1;
op=[];
 len=prod(size(data));
 dptr=0;



 data=bitand(data(:)',255);
 while (len>0)
      toget=min([len skt.max]);
      pbuf=uint8([UDP_POKE bitand(toget,255)]);
      pbuf=[pbuf  bitand(add,255) bitand(floor(add/2.^8),255) bitand(floor(add/2.^16),255) bitand(floor(add/2.^24),255)];
      pbuf=[pbuf  data((1:toget)+dptr)];
      bb=sersendget(skt,pbuf,PPHSIZE);
      if (max(size(bb))==PPHSIZE)
        if ((bb(1:4)==[UDP_POKE_REPLY])&&(toget==bb(5)))
           dptr=dptr+toget;
           len=len-toget;
           add=add+toget;
        end
       end
 end %while len
endfunction

